package net.w_horse.excelpojo.xml.tag;

public enum RetrieveType {
	NONE("none"),
	LABELED_CELL("labeledCell"),
	POINTED_CELL("pointedCell"),
	CONSTANT_VALUE("constantValue"),
	VERTICAL_REPEATS("verticalRepeats"),
	HORIZONTAL_REPEATS("horizontalRepeats"),
	MAPPED_CELL("mappedCell");

	private String value;
	private RetrieveType(String value) {
		this.value = value;
	}
	public String getValue() {
		return this.value;
	}

	public static String getTagName() {
		return "retrieveType";
	}

	public static boolean equals(RetrieveType elementName, String expr) {
		RetrieveType retrieveTypeExpr = getElement(expr);
		return (retrieveTypeExpr == elementName);
	}

	public static boolean equalsIgnoreCase(RetrieveType elementName, String expr) {
		RetrieveType retrieveTypeExpr = getElementIgnoreCase(expr);
		return (retrieveTypeExpr == elementName);
	}

	public boolean equals(String expr) {
		return getValue().equals(expr);
	}
	public boolean equalsIgnoreCase(String expr) {
		return getValue().equalsIgnoreCase(expr);
	}

	public static RetrieveType getElement(String elementName) {
		for (RetrieveType retrieveType : values()) {
			if (retrieveType.equals(elementName)) {
				return retrieveType;
			}
		}
		return NONE;
	}
	public static RetrieveType getElementIgnoreCase(String elementName) {
		for (RetrieveType retrieveType : values()) {
			if (retrieveType.equalsIgnoreCase(elementName)) {
				return retrieveType;
			}
		}
		return NONE;
	}
}
